//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.4

import wesual.Ui       1.0 as UiCtrl
import wesual.Controls 1.0
import wesual.Editor   1.0
import wesual.Stage   1.0

import wesual.data.Core        1.0
import wesual.data.FoodService 1.0

Item {
    property ProductListContainer container

    implicitWidth  : picker.width
    implicitHeight : picker.height

    UiCtrl.UiLargeToolButton {
        id : picker

        anchors.centerIn : parent
        text             : qsTrId("1aeec8a80e95d6ec")
        iconName         : "add"
        onClicked        : flyout.show()

        ProductChooserPopup {
            id : flyout

            onProductsPicked : {
                Editor.context.beginRecordChanges();

                for (var i = 0; i < products.length; ++i) {
                    var newItem = container.createItem();
                    newItem.data.product = products[i];
                }

                Editor.context.endRecordChanges();
                flyout.hide();
            }
        }
    }
}

